//   File:  LED_linear_levels_if.pde
//
//   Use PWM to control the brightness of an LED.
//   Pattern is a linear ramp up to a constant, followed by a linear decrease
//   back to the starting intensity.  Repeat indefinitely.  Timing is controlled
//   by a single loop.  Switching between phases is determined with "if" statements
//   that check the current (estimate of) time.  Timing is still imprecise because the
//   use of loop delays ignores time spent executing commands other than delay()
//  
//   Gerald Recktenwald,  gerry@me.pdx.edu,  20 August 2011

int  LED_pin = 11;               //  must be one of 3, 5, 6, 9, 10 or 11

// -------------
void setup() {                
  pinMode(LED_pin, OUTPUT);      // Initialize pin for output
}

// -------------
void loop() {

  int  i, ncycle, dtwait;                   //  Index, total steps for all three phases, loop delay
  int  v, Vmin=20, Vmax=220;                //  PWM output (v) and min and max values of ramps
  double  ain, bin, aex, bex;               //  Slopes and intercepts of linear output functions
  double dt, dtin, dtpause, dtex, t, t3;    //  Timing parameters

  dt = 0.01;                                //  Time step (seconds). Should be >= 10 milliseconds
  dtwait = dt*1000;                         //  Loop delay (milliseconds) corresponding to dt
  dtin = 2.0;                               //  Time interval for inhale (seconds)
  dtpause = 0.5;                            //  Time interval for pause after inhale (seconds)
  dtex = 2.5;                               //  Time intervalfor exhale (seconds)
  t3 = dtin + dtpause;                      //  Time at end of the pause (seconds)
  ncycle = ( dtin + dtpause + dtex ) / dt;  //  Total time steps in a cycle
  
  // -- Use other time interval and range parameters to compute slopes and intercepts of v(t)
  ain = double(Vmax - Vmin)/dtin;           //  Slope during inhale
  bin = double(Vmin);                       //  Intercept during inhale
  aex = double(Vmin - Vmax)/dtex;           //  Slope during exhale
  bex = double(Vmax) - aex*t3;              //  Intercept during exhale
  
  t = 0.0;
  for ( i=1; i<=ncycle; i++ ) {
    t += dt;
    if ( t <= dtin ) {
      v = int( ain*t + bin );                 //  Inhale
    } else if ( t <= t3 ) {
      v = Vmax;                               //  Pause
    } else {
      v = int( aex*t + bex );                 //  Exhale
    }
    analogWrite(LED_pin, v);
    delay(dtwait);
  }
}
